% OAGM style for electronic-only publication.
% Derived from the UIBK Intelligent and Interactive Systems Report Class.
%
% Redefine (at least) the following for each workshop:
%
\newcommand{\OAGMyear}{2015}
%
% Authors:
% Justus Piater, Stephen Cobeldick, Antonio Rodriguez-Sanchez
%
% justus[dot]piater[at]uibk[dot]ac[dot]at
%
% ### Options and Article Class ###
%
% These commands can be used in .tex:
\newcommand*{\OAGMclass}{OAGM}
\newcommand*{\OAGMversion}{0.2}
\newcommand*{\OAGMreleased}{2015/02/15} % LaTeX date format: yyyy/mm/dd
%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{\OAGMclass}[\OAGMreleased\space\OAGMversion\space OAGM Workshop Class]
%
% TypeSize:
\newcommand*{\@OAGMtypesize}{10pt}
\DeclareOption{10pt}{\edef\@OAGMtypesize{\CurrentOption}}
\DeclareOption{11pt}{\edef\@OAGMtypesize{\CurrentOption}}
\DeclareOption{12pt}{\edef\@OAGMtypesize{\CurrentOption}}
%
% Version for review:
\newif\if@OAGMreview
\@OAGMreviewfalse
\DeclareOption{review}{\@OAGMreviewtrue}
%
% All other options:
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
%
\LoadClass[a4paper,twoside,\@OAGMtypesize]{article}
%
\RequirePackage{xcolor}%      Error message for course-number class-option.
\RequirePackage{hyperref}%    Hyperlinks.
\RequirePackage[all]{hypcap}% Hyperlinks to top of floats.
\RequirePackage[T1]{fontenc}% Improve handling of non-ASCII characters.
\RequirePackage{lmodern}%     Use vector fonts.  A Must with T1 encoding.
%
\if@OAGMreview
\usepackage{lineno}
\renewcommand\thelinenumber{\color[rgb]{0.2,0.5,0.8}\normalfont\sffamily\scriptsize\arabic{linenumber}\color[rgb]{0,0,0}}
\renewcommand\makeLineNumber {\hss\thelinenumber\ \hspace{6mm} \rlap{\hskip\textwidth\ \hspace{6.5mm}\thelinenumber}} 
\linenumbers
\fi
%
\pagestyle{myheadings}
\addtolength{\textheight}{\footskip} % no footer is used
%
% arXiv matters:
%
\def\@OAGMarXiv{Please set OAGMarXiv in LaTeX preamble}
\newcommand{\OAGMarXiv}[1]{\gdef\@OAGMarXiv{#1}}
%
% Title page as per LaTeX, but without the date; also set headings
\renewcommand\maketitle{\par
  \if@OAGMreview
  \author{Anonymous}
  \fi
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\def\@maketitle{%
  \newpage\null%
  \begin{center}%
  \let\footnote\thanks
    {\Large\textbf{\@title}\par}%
    \vskip 1.5em%
    {\lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author%
      \end{tabular}\par}%
  \end{center}%
  \par%
  \vskip 1.5em
  \markboth{\@title}{OAGM Workshop \OAGMyear\
    (\if@OAGMreview Submission for Review\else
    \href{http://arxiv.org/abs/\@OAGMarXiv}{arXiv:\@OAGMarXiv}\fi)}
}

%% define macro for author & affiliation
\newcounter{@dept}
\newcounter{@auth}
\def\dept#1{\unskip$^{#1}$}

\def\department#1{\gdef\@department{#1}}

\def\departmentname{\par
 \begingroup
 \setcounter{@dept}{1}%
 \def\and{\par\stepcounter{@dept}%
 \noindent$^{\the@dept}$\enspace\ignorespaces}%
 \ifnum\c@@dept=1\relax
   \gdef\fnnstart{0}%
 \else
   \xdef\fnnstart{\c@@dept}%
   \setcounter{@dept}{1}%
   \noindent$^{\the@dept}$\enspace
 \fi
 \ignorespaces
 \@department\par
 \vspace{14pt}
 \endgroup}

\renewenvironment{abstract}{%
  \small\quotation\noindent\textbf{\abstractname. }}{\endquotation}

\bibliographystyle{plain}

% The section font sizes and spacing is stolen from llncs.cls:
\renewcommand\section{\@startsection{section}{1}{\z@}%
                       {-18\p@ \@plus -4\p@ \@minus -4\p@}%
                       {12\p@ \@plus 4\p@ \@minus 4\p@}%
                       {\normalfont\large\bfseries\boldmath
                        \rightskip=\z@ \@plus 8em\pretolerance=10000 }}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                       {-18\p@ \@plus -4\p@ \@minus -4\p@}%
                       {8\p@ \@plus 4\p@ \@minus 4\p@}%
                       {\normalfont\normalsize\bfseries\boldmath
                        \rightskip=\z@ \@plus 8em\pretolerance=10000 }}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                       {-18\p@ \@plus -4\p@ \@minus -4\p@}%
                       {-0.5em \@plus -0.22em \@minus -0.1em}%
                       {\normalfont\normalsize\bfseries\boldmath}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                       {-12\p@ \@plus -4\p@ \@minus -4\p@}%
                       {-0.5em \@plus -0.22em \@minus -0.1em}%
                       {\normalfont\normalsize\itshape}}
% End of OAGM.cls
